overall_score();

/**
 * Performs the overall score calculation for the specified models
 */
function overall_score() {
    let templ = Template.GetCurrent();
    let models = get_model_list();

    let occupants = ["DRIVER", "REAR_DRIVER_SIDE"];

    /* The following objects will be populated with values for each occupant */
    let head_score = {};
    let chest_score = {};
    let abdomen_score = {};
    let pelvis_score = {};
    let occ_score = {};
    let occ_capping_limit = {};
    let airbag_deployment_mod = {};
    let seat_belt_mod = {};
    let restraint_system_mod = {};

    for (let m of models) {
        let capping_limit_explanation = "";
        for (let occ of occupants) {
            LogPrint(`Calculating ${m} ${occ} overall score...`);

            /* Create a status object to track whether REPORTER Variables are all present and valid.
             * <success> is initially true but will be set to false if anything missing or invalid. */
            let status = { success: true, missing: [], invalid: [] };

            /* Body region final scores */
            head_score[occ] = get_variable_value(status, `${m}_${occ}_HEAD_FINAL_SCORE`, "float");
            chest_score[occ] = get_variable_value(status, `${m}_${occ}_CHEST_FINAL_SCORE`, "float");
            pelvis_score[occ] = get_variable_value(status, `${m}_${occ}_PELVIS_FINAL_SCORE`, "float");
            abdomen_score[occ] = get_variable_value(status, `${m}_${occ}_ABDOMEN_FINAL_SCORE`, "float");

            /* Body region capping limits */
            let head_capping_limit = get_variable_value(status, `${m}_${occ}_HEAD_CAPPING_LIMIT`, "string");
            let chest_capping_limit = get_variable_value(status, `${m}_${occ}_CHEST_CAPPING_LIMIT`, "string");
            let pelvis_capping_limit = get_variable_value(status, `${m}_${occ}_PELVIS_CAPPING_LIMIT`, "string");
            let abdomen_capping_limit = get_variable_value(status, `${m}_${occ}_ABDOMEN_CAPPING_LIMIT`, "string");

            /* Restraint system Modifiers */
            restraint_system_mod[occ] = 0;
            airbag_deployment_mod[occ] = get_variable_value(
                status,
                `${m}_${occ}_INCORRECT_AIRBAG_DEPLOYMENT_MODIFIER`,
                "float"
            );
            seat_belt_mod[occ] = get_variable_value(
                status,
                `${m}_${occ}_RESTRAINT_SYSTEM_TEST_FAILURE_MODIFIER`,
                "float"
            );
            restraint_system_mod[occ] = airbag_deployment_mod[occ] + seat_belt_mod[occ];

            occ_score[occ] = 0;
            occ_capping_limit[occ] = "*";

            /* If we have all the required variables, calculate the final scores */
            if (status.success) {
                /* Overall occupant score is sum of body region scores. */
                occ_score[occ] = Math.max(
                    0,
                    head_score[occ] +
                        chest_score[occ] +
                        abdomen_score[occ] +
                        pelvis_score[occ] +
                        restraint_system_mod[occ]
                );

                LogPrint(`${m} ${occ} overall score = ${occ_score[occ]}`);

                /* Only remove the overall occupant capping limit if none of the body region
                 * capping limits were exceeded. */
                if (
                    head_capping_limit == "" &&
                    chest_capping_limit == "" &&
                    abdomen_capping_limit == "" &&
                    pelvis_capping_limit == ""
                ) {
                    occ_capping_limit[occ] = "";
                    LogPrint(`Capping limit not applied to ${m} ${occ}.`);
                } else {
                    capping_limit_explanation = `*Capping limit exceeded`;
                    LogPrint(`Capping limit applied to ${m} ${occ}.`);
                    occ_score[occ] = 0;
                }
            } else {
                warn_about_missing_or_invalid_variables(status, `${m} ${occ} overall score calculation`);
            }

            let restraint_system_mod_var = new Variable(
                templ,
                `${m}_${occ}_RESTRAINT_SYSTEM_MODIFIER`,
                `Overall ${occ} restraint system modifier`,
                restraint_system_mod[occ].toString(),
                "String",
                false,
                true
            );

            let overall_occ_score_var = new Variable(
                templ,
                `${m}_${occ}_OVERALL_SCORE`,
                `Overall ${occ} score`,
                occ_score[occ].toString(),
                "String",
                false,
                true
            );

            let overall_occ_capping_limit_var = new Variable(
                templ,
                `${m}_${occ}_OVERALL_CAPPING_LIMIT`,
                `Overall ${occ} capping limit`,
                occ_capping_limit[occ].toString(),
                "String",
                false,
                true
            );
        }
        /* Final scores all start at zero and will remain so if any variables were missing or invalid */
        let overall_score = 0;
        let genneral_modifier = 0;

        /* If we have all the required variables, calculate the final scores */
        let status = { success: true, missing: [], invalid: [] };
        if (status.success) {
            /* incorrect airbag deployment patterns modifier */
            LogPrint(`Retrieving airbag deployment patterns modifier...`);
            let airbag_pattern_mod = get_variable_value(
                status,
                `${m}_INCORRECT_AIRBAG_DEPLOYMENT_PATTERNS_MODIFIER`,
                "float"
            );

            /* incorrect airbag external dimension modifier */
            LogPrint(`Retrieving airbag external dimension modifier...`);
            let airbag_dimension_mod = get_variable_value(
                status,
                `${m}_INCORRECT_AIRBAG_EXTERNAL_DIMENSIONS_MODIFIER`,
                "float"
            );

            /* Door opening modifier */
            LogPrint(`Retrieving door opening modifier...`);
            let door_opening_mod = get_variable_value(status, `${m}_DOOR_OPEN_MODIFIER`, "float");

            /* Door locking modifier */
            LogPrint(`Retrieving door locking modifier...`);
            let door_locking_mod = get_variable_value(status, `${m}_DOOR_LOCKING_FEATURE_FAILURE_MODIFIER`, "float");

            /* Restraint System Locking modifier */
            LogPrint(`Retrieving Restraint System Locking modifier...`);
            let Restraint_locking_mod = get_variable_value(
                status,
                `${m}_INCORRECT_RESTRAINT_RELEASE_MODIFIER`,
                "float"
            );

            if (!status.success) {
                warn_about_missing_or_invalid_variables(status, `${m} airbag deployment patterns modifier`);
                airbag_pattern_mod = 0;
                warn_about_missing_or_invalid_variables(status, `${m} airbag external dimension modifier`);
                airbag_dimension_mod = 0;
                warn_about_missing_or_invalid_variables(status, `${m} door opening modifier`);
                door_opening_mod = 0;
                warn_about_missing_or_invalid_variables(status, `${m} door locking modifier`);
                door_locking_mod = 0;
                warn_about_missing_or_invalid_variables(status, `${m} Restraint System Locking modifier`);
                Restraint_locking_mod = 0;
            }
            genneral_modifier =
                airbag_pattern_mod + airbag_dimension_mod + door_opening_mod + door_locking_mod + Restraint_locking_mod;

            /* total score */
            overall_score = occ_score.DRIVER + occ_score.REAR_DRIVER_SIDE + genneral_modifier;
            LogPrint(`${m} overall score = overall_score`);

            // checks that overall_score is between 0 and 20
            if (overall_score < 0.0) {
                overall_score = 0.0;
            } else if (overall_score > 20.0) {
                overall_score = 20.0;
            }
        } else {
            warn_about_missing_or_invalid_variables(status, `${m} overall score calculation`);
        }

        let genneral_modifier_var = new Variable(
            templ,
            `${m}_GENNERAL_MODIFIER`,
            `Genneral modifier`,
            genneral_modifier.toString(),
            "String",
            false,
            true
        );

        let overall_score_var = new Variable(
            templ,
            `${m}_OVERALL_SCORE`,
            `Overall score`,
            overall_score.toString(),
            "String",
            false,
            true
        );

        let overall_capping_limit_explanation_var = new Variable(
            templ,
            `${m}_OVERALL_CAPPING_LIMIT_EXPLANATION`,
            `Overall Capping limit explanation`,
            capping_limit_explanation,
            "String",
            false,
            true
        );
    }
}
